// Adapted from bevy/examples/ui/ui_material.rs
// and bevy/assets/shaders/custom_ui_material.wgsl
// originally licensed under the MIT license

// Draws a progress bar with properties defined in CustomUiMaterial
#import bevy_ui::ui_vertex_output::UiVertexOutput

@group(1) @binding(0) var<uniform> color: vec4<f32>;
@group(1) @binding(1) var<uniform> progress: vec4<f32>;


@fragment
fn fragment(in: UiVertexOutput) -> @location(0) vec4<f32> {
    // half size of the UI node
    let half_size = 0.5 * in.size;

    // we want the bar to be pill shaped
    // which means the radius has to be half of the height
    let border_radius = vec4(half_size.y);

    // position relative to the center of the UI node
    let p = in.uv * in.size - half_size;

    // select radius for the nearest corner
    let rs = select(border_radius.xy, border_radius.wz, 0.0 < p.y);
    let radius = select(rs.x, rs.y, 0.0 < p.x);

    // distance along each axis from the corner
    let d = half_size - abs(p);

    // return a transparent value for positions outside of the radius
    let q = radius - d;

    let in_radius = radius >= min(max(q.x, q.y), 0.0) + length(vec2(max(q.x, 0.0), max(q.y, 0.0)));
    let in_progress = in.uv.x < progress.x;

    return select(vec4(0.0), color, in_radius && in_progress);
}
