#!/bin/sh
# Gitlab release publish script
# args:
# 1. token
# 2. instance name (i.e. https://example.com)
# 3. repo (as number)
# 4. release message
# 5. release name
# 6. release tag

# auth data
token="$1" # secrets.GITLAB_TOKEN
shift 1
# repo data
instance="$1" # vars.GITLAB_CI_API_V4_URL
repo="$2" # vars.GITLAB_CI_PROJECT_ID
shift 2
# release data
name="$1"
tag="$2"

# create file to store link data
touch .links

# upload artifacts
echo Uploading artifacts
find artifacts -type f | \
    while read -r file; do
        upload_path="$instance/projects/$repo/packages/generic/tte/$tag/$(basename "$file" | jq -jRr @uri )"
        curl \
            --fail \
            --header "PRIVATE-TOKEN: $token" \
            --upload-file "$file" \
            "$upload_path"
        # add links to file
        echo "{ \"name\": \"$(basename "$file")\", \"url\": \"$upload_path\", \"link_type\":\"other\" }" >> .links
    done

# add external links
find external-artifacts -type f | \
    while read -r file; do
        echo "{ \"name\": \"$(basename "$file")\", \"url\": \"$(cat "$file")\", \"link_type\":\"other\" }" >> .links
    done

echo Publishing release

# create release
cat <<JSON > .gitlab-release
{
  "name": "$name",
  "tag_name": "$tag",
  "description": $(jq -Rsa . .msg),
  "milestones": [],
  "assets": {
    "links": $(jq -s . .links)
  }
}
JSON
cat .gitlab-release
curl --fail \
    --header 'Content-Type: application/json' \
    --header "PRIVATE-TOKEN: $token" \
    --data '@.gitlab-release' \
    --request POST "$instance/projects/$repo/releases"
