use bevy::math::Vec2;
use bevy_egui::egui::{self, Color32, CornerRadius};

// https://github.com/catppuccin/catppuccin

// general
pub const TITLE_FONT_NAME: &str = "title_font";
pub const PARAGRAPH_FONT_NAME: &str = "main_font";
pub const BOLD_FONT_NAME: &str = "bold_font";
pub const MONOSPACE_FONT_NAME: &str = "mono_font";
pub const SPACE_SIZE: f32 = 0.015;
pub const MARGIN_SIZE: f32 = 0.001;

/// resolution of the "app-icon.png" file
pub const APP_ICON_RESOLUTION: f32 = 512.;

// colors
pub const BACKGROUND_COLOR: Color32 = egui::Color32::from_rgb(245, 224, 220); // rosewater
pub const TITLE_TEXT_COLOR: Color32 = egui::Color32::from_rgb(49, 50, 68); // surface0
pub const BUTTON_COLOR: Color32 = egui::Color32::from_rgb(88, 91, 112); // Surface2
pub const BUTTON_TEXT_COLOR: Color32 = egui::Color32::from_rgb(205, 214, 244); // text
pub const NORMAL_TEXT_COLOR: Color32 = egui::Color32::from_rgb(88, 91, 112); // surface2

// buttons
pub const PRIMARY_BUTTON_SIZE: Vec2 = Vec2::new(0.4, 0.1);
pub const PRIMARY_BUTTON_TEXT_SIZE: f32 = 0.05;
pub const SECONDARY_BUTTON_SIZE: Vec2 = Vec2::new(0.2, 0.075);
pub const SECONDARY_BUTTON_TEXT_SIZE: f32 = 0.03;

//text
pub const BIG_TEXT_SIZE: f32 = 0.1;
pub const HEADING_SIZE: f32 = 0.035;
pub const SMALL_HEADING_SIZE: f32 = 0.03;
pub const SMALL_TEXT_SIZE: f32 = 0.022;

// rounds
pub const BETWEENROUNDS_BACKGROUND_COLOR: Color32 = egui::Color32::from_rgb(249, 226, 175); // yellow
pub const GAMEOVER_BACKGROUND_COLOR: Color32 = egui::Color32::from_rgb(243, 139, 168); // red
pub const OVERLAY_TITLE_TEXT_COLOR: Color32 = egui::Color32::from_rgb(30, 30, 46); // base
pub const GRID_TEXT_COLOR: Color32 = egui::Color32::from_rgb(69, 71, 90); // surface 1

// metrics
pub const METRICS_BAR_BG_COLOR: Color32 = egui::Color32::from_rgb(242, 205, 205);
pub const METRICS_BAR_FG_COLOR: Color32 = egui::Color32::from_rgb(203, 166, 247);
pub const METRICS_BAR_TEXT_COLOR: Color32 = egui::Color32::from_rgb(24, 24, 37);
// plot
pub const PLOT_STROKE_WIDTH: f32 = 4.0;
pub const PLOT_TARGET_COLOR: Color32 = egui::Color32::from_rgb(243, 139, 168);
pub const PLOT_FOOD_COLOR: Color32 = egui::Color32::from_rgb(166, 227, 161);
pub const PLOT_MATERIALS_COLOR: Color32 = egui::Color32::from_rgb(139, 213, 202);
pub const PLOT_MONEY_COLOR: Color32 = egui::Color32::from_rgb(249, 226, 175);
pub const PLOT_MAX_WIDTH: f32 = 0.6;
pub const PLOT_MAX_HEIGHT: f32 = 0.6;

// ingame card hand & inventory
/// slot background color
pub const INV_SLOT_BG: Color32 = egui::Color32::from_rgb(244, 219, 214); // macchiato: rosewater
/// slot stroke color
pub const INV_SLOT_STROKE: Color32 = egui::Color32::from_rgb(240, 198, 198); // macchiato: flamingo
/// slot hover stroke color
pub const INV_SLOT_STROKE_HOVER: Color32 = egui::Color32::from_rgb(242, 205, 205); // mocha: flamingo
/// slot hover stroke color for selected slots
pub const INV_SLOT_STROKE_HOVER_SELECTED: Color32 = egui::Color32::from_rgb(238, 153, 160); // frappe: flamingo
/// slot stroke color (when selected)
pub const INV_SLOT_STROKE_SELECTED: Color32 = egui::Color32::from_rgb(221, 120, 120); // latte: flamingo
/// default slot stroke width
/// percent of the outer margin
pub const INV_SLOT_STROKE_WIDTH: f32 = 1.4;
/// stroke width when selected
/// percent of the outer margin
pub const INV_SLOT_STROKE_WIDTH_SELECTED: f32 = 1.4;
/// the slot corner radius
pub const INV_SLOT_RADIUS: f32 = 6.;
/// inner slot margin as percent of the width
pub const INV_SLOT_INNER_MARGIN: f32 = 0.12;
/// outer slot margin as percent of the width
pub const INV_SLOT_OUTER_MARGIN: f32 = 0.04;
/// percent of smallest display edge
pub const INV_SLOT_SIZE: f32 = 0.08;

/// slot count of the opened inventory in landscape mode
pub const CREATIVE_INV_SLOT_COUNT_LANDSCAPE: usize = 6;
/// slot count of the opened inventory in portrait mode
pub const CREATIVE_INV_SLOT_COUNT_PORTRAIT: usize = 3;
/// width of the opened inventory in landscape mode
pub const CREATIVE_INV_SIZE_LANDSCAPE: f32 = 0.6;
/// width of the opened inventory in portrait mode
pub const CREATIVE_INV_SIZE_PORTRAIT: f32 = 0.6;

// popup window
pub const POPUP_COLOR_BG: egui::Color32 = INV_SLOT_BG;
pub const POPUP_RADIUS: egui::CornerRadius = CornerRadius::same(6);
pub const POPUP_STROKE_COLOR: egui::Color32 = egui::Color32::from_rgb(240, 198, 198);

/// preferred outer margin of UI elements
pub const OUTER_MARGIN: f32 = 8.0;
pub const INNER_MARGIN: f32 = 6.0;

pub const REDRAW_COLOR: egui::Color32 = egui::Color32::from_rgb(175, 38, 60);
pub const REDRAW_AFFORD_COLOR: egui::Color32 = egui::Color32::from_rgb(54, 100, 50);
pub const REDRAW_TIMEOUT_OVERLAY_OPACITY: f32 = 0.6;
/// opacity used for the redraw icon when the progress animation is shown
pub const REDRAW_PAID_ICON_OPACITY: f32 = 0.2;
/// number of seconds per shadow animation fade in and out
pub const REDRAW_FREE_ANIMATION_PERIOD: f32 = 2.0;
/// number of pixels the shadow will expand
pub const REDRAW_FREE_ANIMATION_DISTANCE: f32 = 5.0;
/// color of the shadow
/// does not need to be semi-transparent, because the shadow blur will cause it to fade out
pub const REDRAW_FREE_ANIMATION_COLOR: egui::Color32 = egui::Color32::from_rgb(180, 190, 254);

// error screen
pub const ERROR_BACKGROUND_COLOR: Color32 = egui::Color32::from_rgb(235, 160, 172); // red
