use super::super::theme::*;
use bevy::{ecs::system::ResMut, math::Vec2};
use bevy_egui::egui::{self, FontId, RichText};

use crate::{i18n::Localization, prelude::*, settings::ActiveSettingsBank};

pub fn audio_tab(
    ui: &mut egui::Ui,
    window: Vec2,
    mut settings: ResMut<ActiveSettingsBank>,
    localization: &Localization,
) {
    egui::Grid::new("audio_settings")
        .num_columns(2)
        .spacing([window.x / 20.0, window.y / 150.0])
        .striped(true)
        .show(ui, |ui| {
            ui.add(egui::Label::new(
                RichText::new(localization.translate("master-volume"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            ));
            ui.add(
                egui::Slider::new(&mut settings.audio.master_volume, 0.0..=1.0)
                    .custom_formatter(|n, _| format!("{:.0}", n * 100.0))
                    .custom_parser(|s| s.parse::<f64>().map(|n| n / 100.0).ok()),
            );
            ui.end_row();
            ui.add(egui::Label::new(
                RichText::new(localization.translate("music-volume"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            ));
            ui.add(
                egui::Slider::new(&mut settings.audio.music_volume, 0.0..=1.0)
                    .custom_formatter(|n, _| format!("{:.0}", n * 100.0))
                    .custom_parser(|s| s.parse::<f64>().map(|n| n / 100.0).ok()),
            );
            ui.end_row();
            ui.add(egui::Label::new(
                RichText::new(localization.translate("sounds-volume"))
                    .font(FontId::new(
                        window.y * SMALL_TEXT_SIZE,
                        egui::FontFamily::Name(PARAGRAPH_FONT_NAME.into()),
                    ))
                    .color(NORMAL_TEXT_COLOR),
            ));
            ui.add(
                egui::Slider::new(&mut settings.audio.sfx_volume, 0.0..=1.0)
                    .custom_formatter(|n, _| format!("{:.0}", n * 100.0))
                    .custom_parser(|s| s.parse::<f64>().map(|n| n / 100.0).ok()),
            );
            ui.end_row();
        });
}
