use bevy::input::mouse::MouseButton;
use serde::{Deserialize, Serialize};

use super::keybindings::WithTranslationID;

#[derive(Serialize, Deserialize, Debug, Clone)]
#[serde(default)]
pub struct MouseSettings {
    pub pan: MouseButton,
    pub orbit: MouseButton,
    pub place: MouseButton,
    pub destroy: MouseButton,
}

impl Default for MouseSettings {
    fn default() -> Self {
        Self {
            pan: MouseButton::Left,
            orbit: MouseButton::Right,
            place: MouseButton::Left,
            destroy: MouseButton::Right,
        }
    }
}

impl WithTranslationID for MouseButton {
    fn get_translation_id(&self) -> &str {
        match self {
            MouseButton::Left => "left-click",
            MouseButton::Right => "right-click",
            MouseButton::Middle => "middle-mouse-button",
            MouseButton::Back => "back-mouse-button",
            MouseButton::Forward => "forward-mouse-button",
            MouseButton::Other(_) => "mouse-button-unknown",
        }
    }
}
