use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Debug, Clone)]
#[serde(default)]
pub struct AudioSettings {
    pub master_volume: f32,
    pub music_volume: f32,
    pub sfx_volume: f32,
}
impl Default for AudioSettings {
    fn default() -> Self {
        Self {
            master_volume: 1.0,
            music_volume: 1.0,
            sfx_volume: 1.0,
        }
    }
}

#[allow(dead_code)]
impl AudioSettings {
    pub fn get_sfx_percent(&self) -> f32 {
        (self.master_volume.clamp(0.0, 1.0)) * (self.sfx_volume.clamp(0.0, 1.0))
    }
    pub fn get_music_percent(&self) -> f32 {
        (self.master_volume.clamp(0.0, 1.0)) * (self.music_volume.clamp(0.0, 1.0))
    }
}
