use bevy::app::Plugin;
pub mod animations;
mod bee;
pub mod blur;
pub mod build_grid;
pub mod cell_water;
mod chameleon_tile;
pub mod debug_text;
pub mod light;
pub mod placement_animation;
mod rewards;
mod rgb_tile;
pub mod visualize_relevant;
mod voronoi;
pub mod water;

pub struct VisualsPlugin;

impl Plugin for VisualsPlugin {
    fn build(&self, app: &mut bevy::prelude::App) {
        app.add_plugins(animations::TileAnimations);
        app.add_plugins(build_grid::BuildGridPlugin);
        app.add_plugins(debug_text::DebugTextPlugin);
        app.add_plugins(bee::BeePlugin);
        app.add_plugins(light::LightPlugin);
        app.add_plugins(voronoi::VoronoiPlugin);
        app.add_plugins(cell_water::CellWaterPlugin);
        app.add_plugins(water::WaterPlugin);
        app.add_plugins(placement_animation::PlacementAnimationPlugin);
        app.add_plugins(visualize_relevant::VisualizeRelevantTilesPlugin);
        app.add_plugins(rgb_tile::RgbTilePlugin);
        app.add_plugins(blur::BlurPlugin);
        app.add_plugins(chameleon_tile::ChameleonTilePlugin);
        app.add_plugins(rewards::RewardsVisualPlugin);
    }
}
