use bevy::prelude::{SubStates, World};

use super::CampaignLevelProgress;

/// collection of multiple levels into one logical group
/// i.e. collectiong everything relating to the bot api into one group
pub trait Group: SubStates {
    /// returns the group id
    /// useful for cli level selection
    /// should also be used for translations as campaign-group-<id>
    fn get_id(&self) -> &'static str;
    /// register the group state with the bevy app
    /// also registers the levels
    fn register(app: &mut bevy::prelude::App);
    /// returns the id of the currently selected level
    fn get_level_id(&self) -> &'static str;
    /// custom init function to initialize group data
    fn init(_world: &mut World) {}
}

/// every level is based around a story line
pub trait Level: SubStates {
    /// returns the segment id
    /// as campaign-group-<group_id>-<level_id>-<segment-id>
    fn get_id(&self) -> &'static str;
    /// returns an instance of the next storyline segment
    /// returns `None` if the current segment is the last segment
    fn next(&self) -> Option<Self>;
    /// register this storyline with bevy
    /// including all the step conditions
    fn register(app: &mut bevy::prelude::App);
    /// returns the id of this level
    fn get_level_id(&self) -> &'static str;
    /// returns the generalized progress state the level variant is in
    fn get_progress(&self) -> CampaignLevelProgress;
    /// custom init function to initialize level data
    fn init(_world: &mut World) {}
}
