use crate::{
    game::{
        gamemodes::campaign::levels::CampaignWettbewerb, hand::RandomCore, rewards::RewardEvent,
        GameSimSet,
    },
    DisplayMode,
};
use bevy::prelude::*;

use super::CampaignWettbewerbState;

pub struct CampaignWettbewerbWeihnachtenPlugin {
    pub display_mode: DisplayMode,
}
impl Plugin for CampaignWettbewerbWeihnachtenPlugin {
    fn build(&self, app: &mut App) {
        app.init_resource::<ChristmasRewardsCount>();
        app.add_systems(
            Update,
            count_christmas_rewards
                .run_if(in_state(CampaignWettbewerbState::InRound))
                .in_set(GameSimSet::AfterSim),
        );
    }
}

fn count_christmas_rewards(
    mut rev_event: EventReader<RewardEvent>,
    mut count: ResMut<ChristmasRewardsCount>,
) {
    if !rev_event.is_empty() {
        **count += rev_event.len();
        rev_event.clear();
    }
}

#[derive(Debug, Resource, Default, DerefMut, Deref)]
struct ChristmasRewardsCount(pub usize);

fn weihnachten_init(world: &mut World) {
    let mut rng_core = world
        .get_resource_mut::<RandomCore>()
        .expect("The corresponding plugin is added by the level group plugin");
    rng_core.change_seed("weihnachten");
    let mut rev_count = world
        .get_resource_mut::<ChristmasRewardsCount>()
        .expect("ChristmasRewrdsCount Resource did not exists, but it should exists always.");
    **rev_count = 0;
}

define_level!(
    CampaignWettbewerb::WettbewerbWeihnachten,
    init: weihnachten_init,
    story: [
        {
            id: "intro"
        },
        {
            ref: Rewards,
            id: "story-rewards",
            goal: |count: Res<ChristmasRewardsCount>| {**count >= 8}
        },
        {
            id: "done"
        }
    ]
);
