use crate::DisplayMode;
use bevy::prelude::*;
#[cfg(feature = "graphics")]
use camera::CampaignCameraTutorialPlugin;

#[cfg(feature = "graphics")]
pub mod camera;

pub struct CampaignTutorialPlugin {
    pub display_mode: DisplayMode,
}
impl Plugin for CampaignTutorialPlugin {
    #[cfg(feature = "graphics")]
    fn build(&self, app: &mut App) {
        app.add_plugins(CampaignCameraTutorialPlugin {
            display_mode: self.display_mode,
        });
    }
    #[cfg(not(feature = "graphics"))]
    fn build(&self, _app: &mut App) {}
}
