# 💾 Installation
To use TerraTactician Expandoria you have a couple of options. 
Generally you can choose between
- [running TTE online](#web)
- installing TTE locally
- using TTE without installing it
- [building it yourself](./building.md)

If you want to build it your self, visit [our build guide](./building.md) \
Otherwise follow the guide below and visit our [Release Page (gitlab)](https://vccourses.cs.ovgu.de/swp/terratactician-expandoria/-/releases) or [Release Page (codeberg)](https://codeberg.org/terratactician-expandoria/game/releases).

## 💻 TerraTactician Expandoria Game
### 🌐 Web
Visit our [official website](https://terratactician-expandoria.codeberg.page/) 
and click [play online](https://terratactician-expandoria.codeberg.page/game).

If you want to try a nightly version go to: [TTE nightly](https://terratactician-expandoria.codeberg.page/game/@pages-nightly/)

### 🐧 Linux

Usage without installation:
- Visit the release page and download `tte-linux-amd64-[version].tar.gz`.
- Unpack this archive to your desired location.
- Run it by executing `terratactician-expandoria`

Usage with installation (debian):
- Visit the release page and download `tte-linux-amd64-[version].deb`.
- Install it e.g. with apt.
- The app should be executable with the command `terratactician-expandoria` or via the system menu.

### 🪟 Windows

Usage without installation:
- Visit the release page and download `tte-windows-amd64-[version].zip`.
- Unpack this archive to your desired location.
- Run it by executing `terratactician-expandoria`

Usage with installation (`.msi`):
- Visit the release page and download `tte-windows-amd64-[version].msi`.
- Install it by double clicking it. NOTE: This msi file is not signed. By installing it you trust us / our build system.
- The app should be executable over the windows menu.
- Additionally you can add the app to your path environment variable. Then it will be executable by command. The executable is usually saved at: `C:\\Program Files (x86)\terratactician-expandoria\terratactician-expandoria.exe`

### 📱 Android (Experimental)
Android is currently experimental, due to a couple of ui bugs and an experimental build pipeline.

You can install it by visiting the [android release page][android-releases]
and downloading the `.apk` file. Afterwards, install the app by clicking on the
downloaded file (You might have to enable *APK sideloading*). \
Alternatively, you can install the Game using [F-Droid][fdroid]. \
Once installed, the game will shop up in the app list.

[android-releases]: https://codeberg.org/terratactician-expandoria/android/releases
[fdroid]: https://f-droid.org/en/packages/page.codeberg.terratactician_expandoria/

### 📚 Others
We are not able to build TerraTactician Expandoria for every platform and architecture, due to hardware limitations. 
e.g. it is almost impossible for us to serve a prebuild IOS/MacOS version, due to their locked up environment. 

But there are still some options:
- Use the web version: [Web](#web)
- Compile your self: [See our build guide](./building.md)

If nothing works, 
you could [open an issue](https://codeberg.org/terratactician-expandoria/game/issues) 
or contact us (i.e via email) and we will find a solution.
