# ✅ Writing tests

To ensure proper application functionallity features and components should be tested.

As per the [official rust book](https://doc.rust-lang.org/book/ch11-03-test-organization.html),
we separate our tests by test type.
Intgration tests, which should be used to test application-level behaviour,
should be placed in the `tests` folder in the root of the source.
Unit tests, which are used to test behaviour of standalone functions (i.e. Coordinate conversion),
should be placed inside a private `tests` module inside the file that implements the functionallity:
```rust
#[cfg(test)]
mod tests {
    // tests go here
}
```

After adding your tests, run `cargo test` to make sure all test pass.
Our CI runs `cargo test` on push for every merge request to make sure that everything functions as expected.

To learn more about writing tests in rust, 
have a look at [the official rust book](https://doc.rust-lang.org/book/ch11-01-writing-tests.html)
and for a bevy specific testing guide,
consider checking out the [bevy book](https://bevy-cheatbook.github.io/patterns/system-tests.html)
