# 🌳 Logging

Logging makes it easier to debug application functionality and state,
especially when deployed in production.

We currently use the bevy-provided logging library [bevy_log](https://docs.rs/bevy_log/latest/bevy_log/).
Which in turn reexports logging macros from the [tracing](https://docs.rs/tracing/latest/tracing/) library.

You can find out more by looking at the `docs.rs` pages,
or having a look at the [unoffical bevy cheat book](https://bevy-cheatbook.github.io/fundamentals/log.html):

> Bevy offers a logging framework that is much more advanced than simply using println/eprintln from Rust. \
> Log messages can have metadata, like the level, timestamp, and Rust module where it came from. 
> You can see that this metadata is printed alongside the contents of the message.

## 🎚 Log levels
The `tracing` crates provides [multiple log levels](https://docs.rs/tracing/latest/tracing/struct.Level.html#implementations). (ordered by verbosity):

- `error`: very serious errors
- `warn`: hazardous situations
- `info`: useful information
- `debug`: lower priority information
- `trace`: often extremely verbose, information

## 📨 Printing log messages
To print a log message with a specific level of verbosity,
you can simply use the provided macros, which should be automatically imported.

You can use them just like you would other print macros, like `println!`:
```rust
info!("Loading asset {}", "assets/demo");
```

## 📜 Viewing logs
By default bevy prints log messages to the console window, 
in which you run the app.

To control the target log level and filter log messages,
you can set the `RUST_LOG` environment variable (default: `info`).
```bash
RUST_LOG="warn" cargo run
```
To disable the stdout log messages set the `RUST_LOG` level to `off`.\
If you need more advanced configuration options, 
have a look at the filter guide of the [LogPlugin](https://docs.rs/bevy_log/latest/bevy_log/struct.LogPlugin.html).

If you enable the `file-logger` feature,
the log messages will no longer be printed to stdout,
but instead they are saved to a log file in the application data directory.
On most Linux distros this is `~/.local/share/terratactician-expandoria`. \
- the file logger is configured to rollover (overwrite) the log file after an hour
- it is recommended to enable the `file-logger` feature when building releases
