# Assets

This document explores different ways to contribute assets. \
We'd be honored if you added the source for your asset to our
[artwork repo](https://codeberg.org/terratactician-expandoria/artwork).

Before submitting assets, please ensure that they are licensed appropriately.
The license has to be `AGPL-3.0` compatible,
and ideally it should be possible to publish the icon under `CC-BY-SA`. \
Once you have added your asset, you should also add it to the License file
of the section.

**NOTE**: Working with assets, especially loading and
displaying them, requires some coding knowledge. \
Feel free to reach out if you need help, or want to suggest assets.

## Tiles

Currently, most of our assets are taken from the
[Kenney Hexagon Kit](https://kenney.nl/assets/hexagon-kit). \
Ideally, new tiles should roughly have the same style. \
The tile models should also use the color map from the `Textures` folder.
We have replaced the color map to use the [catppuccin](https://github.com/catppuccin/catppuccin) colors,
which are in use by the rest of the game as well.

When changing tile models, you should replace the `glb` file in
`assets/models` and place the source file in the `extra-tiles` folder in
the *artwork repo*. \
Afterwards, you can use the `render.sh` script in the `previews` folder in
the *artwork repo* to generate the preview image.

When adding new tiles, you have to add proper code for tile behavior
and register the model and preview in the `src/game/tiles/mod.rs` file.

Your `glb` file may also contain tile animations. \
These can also be registered in `tiles/mod.rs`.
Take a look at the `get_asset_animation(&self)` method for more information.

## Icons

You can find information on the icon format in the
[`icons` folder](https://codeberg.org/terratactician-expandoria/artwork/src/branch/main/icons)
in the *artworks repo*. \
The resulting `.png` should be placed in `assets/icon/buttons`.

When adding new icons, you have to register the icon in the asset loader. \
In most cases, you should be able to do the following:
```rust
// create asset collection
define_asset_collection!(
    AboutIcon, // name of the collection
    // "!" indicates that the icon is required
    !open : Image = "icons/buttons/about.png", // icon path
    // [...] add more icons if you want
    // error message to show if the required icons fail to load
    err : "buttton-icon-missing" "Button icon missing." "button-icon-missing-desc" "You can not use a couple of buttons without the icons"
);
// register the asset collection in the plugin
app.register_asset_collection::<AboutIcon>();
```

## Buttons

Most of our buttons are currently single-color filled egui buttons. \
This means that in order to change their appearance, the code would have to
be rewritten.

[Some screens and components](https://codeberg.org/terratactician-expandoria/game/issues/283) might be using bevy ui.
Bevy UI has native texture slicing support, but you still need coding knowledge to implement it. \
You should create a new asset collection:
```rust
define_asset_collection!(
    ScreenDecoration,
    !panel31_filled : Image = "decoration/panel-031.png",
    // TODO error message
);
// register the collection
app.register_asset_collection::<ScreenDecoration>();
```
Afterwards, you can reference the resource in the layout function and define a texture slicer:
```rust
let slicer = TextureSlicer {
    border: BorderRect::square(22.0),
    center_scale_mode: SliceScaleMode::Stretch,
    sides_scale_mode: SliceScaleMode::Stretch,
    max_corner_scale: 1.4,
};
```
Lastly, add an `ImageNode` to the button, which references the resource image and the slicer:
```rust
ImageNode {
    image: decoration.panel31_transparent.clone(),
    image_mode: NodeImageMode::Sliced(slicer.clone()),
    ..default()
},
```


## Sounds

Audio files should be placed in `assets/sounds`. \
Assuming that the file you added is supposed to be used for a sound effect,
it should be registered in `src/game/audio/effects.rs`. \
You also have to add the trigger logic, if desired.

## Fonts

Fonts should be placed in `assets/fonts`.
Afterwards, they have to be registered in the following places:
- [font loading code](https://codeberg.org/terratactician-expandoria/game/src/branch/main/src/ui/font_loader.rs)
- [egui font registration](https://codeberg.org/terratactician-expandoria/game/src/branch/main/src/ui/mod.rs)
