# 💬 Contributing

## 📫 Commit-message style
We do not enforce a specific commit style,
however you are encouraged to have a look at how bigger project handle commit messages,
like the [linux kernel](https://www.kernel.org/doc/html/latest/process/submitting-patches.html#describe-your-changes):

> Describe your problem. Whether your patch is a one-line bug fix or 5000 lines of a new feature, there must be an underlying problem that motivated you to do this work. [...] \
> Describe user-visible impact. [...] But also describe non-obvious costs. [...] \
> Once the problem is established, describe what you are actually doing about it in technical detail. [...] \
> Describe your changes in imperative mood, e.g. “make xyzzy do frotz” instead of “[This patch] makes xyzzy do frotz” or “[I] changed xyzzy to do frotz”, as if you are giving orders to the codebase to change its behaviour. [...]


## 📄 Auto-Formatting & Hooks
To keep the code formatted properly,
we use git hooks to format files before committing.

You can easily add git hooks using the following command:
``` sh
git config core.hooksPath ./hooks
```

Afterwards, the `pre-commit` hook will automatically be executed,
when you commit your changes:
``` sh
git add # some files
git commit
```

## 🔬 Working on TTE
To learn more about libraries and project layout, you can check out more of our contribution guide:
- [improve debug output using logging](./logging.md)
- [translating your code](./translations.md)
- [ensuring proper functionality using tests](./testing.md)

## 📚 External resources
Here is a collection of useful resources when working on writing code:
- [rust book](https://doc.rust-lang.org/stable/book/)
- [official bevy website](https://bevyengine.org/)
- [bevy docs](https://docs.rs/bevy/latest/bevy/)
- [unofficial bevy book](https://bevy-cheatbook.github.io/)
- [bevy cheatbook](https://bevy-cheatbook.github.io/cookbook.html)
- [Red Blob Games: Hexagonal Grids Guide](https://www.redblobgames.com/grids/hexagons/)
