apt install -y -qq wixl libxml-xpath-perl

find assets | \
wixl-heat \
    --prefix assets/ \
    --component-group tteAssets \
    --directory-ref="ASSETSREF" \
    --var var.AssetsDir \
> dist/assets.wxs

# Use weird bash script to combine both xml files
echo """<?xml version='1.0' encoding='windows-1252'?>
<Wix xmlns='http://schemas.microsoft.com/wix/2006/wi'>
""" > dist/build.wxs

xpath -q -e //Wix/Product dist/tte.wxs >> dist/build.wxs
xpath -q -e //Wix/Fragment dist/assets.wxs >> dist/build.wxs

echo "</Wix>" >> dist/build.wxs


wixl -v dist/build.wxs -D AssetsDir="../assets" -D Version="$(grep -oP '(?<=^version = ")[^"]*' Cargo.toml)" -o $1

