#import bevy_pbr::{
    mesh_view_bindings::view,
    utils::coords_to_viewport_uv,
}


@group(2) @binding(0) var<uniform> r: vec4<f32>;

struct Vertex {
    @builtin(instance_index) instance_index: u32,   
    @location(0) pos: vec3<f32>,
    @location(1) uv: vec2<f32>,
};

struct VertexOutput {
    @builtin(position) pos: vec4<f32>,
    @location(0) centroid: vec2<f32>,
};

@vertex
fn vertex(vertex: Vertex) -> VertexOutput {
    var out: VertexOutput;
    // pas vertex position and centroid coordinate to fragment
    out.pos = vec4<f32>(vertex.pos, 1.0);
    out.centroid = vertex.uv;
    return out;
}

struct FragmentInput {
    @builtin(position) pos: vec4<f32>,
    @location(0) centroid: vec2<f32>,
};

struct Pixel {
    @builtin(frag_depth) depth: f32,
	@location(0) color: vec4<f32>,
}

@fragment
fn fragment(input: FragmentInput) -> Pixel {
    var px: Pixel;
    let viewport_uv = coords_to_viewport_uv(input.pos.xy, view.viewport);

    // calculate distance to centroid: use value as depth value, to get cut overlaps.
    px.depth = 1 - length(viewport_uv-input.centroid) / r.x;
    if px.depth < 0.0 {
        discard;
    }

    // use distance to centroid as red channel gray scale image.
    let tone = 1 - px.depth;
    px.color = vec4<f32>(tone, 0.0, 0.0, 1.0);
    
    return px;
}