#import bevy_sprite::mesh2d_vertex_output::VertexOutput

@group(2) @binding(0) var<uniform> water_color: vec4<f32>;
@group(2) @binding(1) var<uniform> ripple_color: vec4<f32>;
@group(2) @binding(2) var base_color_texture: texture_2d<f32>;
@group(2) @binding(3) var base_color_sampler: sampler;

// increase = makes the bubble bigger 
const lowerRamp: f32 = 0.01;
// decrease = makes the ripples bigger
const upperRamp: f32 = 0.1;
// controls blure, will influence effect of values above
const blurTexels: i32 = 1;
const texelOffset: f32 = 7.0;

/// returns blured red channel of pixel
fn blur(
    uv: vec2<f32>, 
) -> f32 {
    let texture_size: vec2<u32> = textureDimensions(base_color_texture);
    let texel_size: f32 = texelOffset / 512.;
    var color = 0.0;
    let place_size = f32((blurTexels*2 + 1)*(blurTexels*2 + 1));
    // average area
    for(var x = -blurTexels; x<=blurTexels; x+=1){
        for(var y = -blurTexels; y<=blurTexels; y+=1){
            let factor = 1/place_size;

            color += textureSample(
                base_color_texture, 
                base_color_sampler, 
                uv + vec2<f32>(f32(x),f32(y)) * texel_size
            ).x * factor;
        }
    }
    return color;
}

@fragment
fn fragment(mesh: VertexOutput) -> @location(0) vec4<f32> {
    let voronoi = textureSample(base_color_texture, base_color_sampler, mesh.uv).x;
    let smoothed = blur(mesh.uv);

    // compute water <- ramp(voronoi - smoothed)
    let color = voronoi - smoothed;
    let ramp = clamp((color-lowerRamp)/(upperRamp-lowerRamp),0.0,1.0);

    // mixing ramp value between water and ripple color.
    return mix(water_color, ripple_color, ramp);
}