#!/bin/sh
# Forgejo release publish script
# args:
# 1. token
# 2. instance name (i.e. https://codeberg.org)
# 3. repo (as owner/repo)
# 4. release message
# 5. release name
# 6. release tag
# 7. release commitish

# auth data
token="$1"
shift 1
# repo data
instance="$1"
repo="$2"
shift 2
# release data
message="$1"
name="$2"
tag="$3"
commitish="$4"

set -e

echo Generating release post data
# save release message
cat <<MSG > .msg
$message
MSG

cat <<EOF > .release.json
{
    "body": $(jq -Rsa . .msg),
    "draft": true,
    "hide_archive_links": false,
    "name": "$name",
    "prerelease": false,
    "tag_name": "$tag",
    "target_commitish": "$commitish"
}
EOF

api_base="$instance/api/v1/repos/$repo/releases"

echo Uploading release
echo "Endpoint: $api_base"
curl -X 'POST' --fail \
    "$api_base" \
    -H 'Accept: application/json' \
    -H "Authorization: token $token" \
    -H 'Content-Type: application/json' \
    --data-binary '@.release.json' | jq -r '.id' > .release-id

echo "Release created as $(cat .release-id)"

# publish file artifacts
echo Uploading file artficacts
find artifacts -type f | \
    while read -r file; do
        curl -X 'POST' --fail \
            "$api_base/$(cat .release-id)/assets?name=$(basename "$file" | jq -jRr @uri)" \
            -H 'Accept: application/json' \
            -H "Authorization: token $token" \
            -H 'Content-Type: multipart/form-data' \
            -F "attachment=@$file"
    done

# publish external artifacts
echo Adding external artfiacts
find external-artifacts -type f | \
    while read -r file; do
        curl -X 'POST' --fail \
            "$api_base/$(cat .release-id)/assets?name=$(basename "$file" | jq -jRr @uri)" \
            -H 'Accept: application/json' \
            -H "Authorization: token $token" \
            -H 'Content-Type: multipart/form-data' \
            -F "external_url=$(cat "$file")"
    done

# publish release
echo Publishing release
curl -X 'PATCH' --fail \
    "$api_base/$(cat .release-id)" \
    -H 'Accept: application/json' \
    -H "Authorization: token $token" \
    -H 'Content-Type: application/json' \
    -d '{ "draft": false }'
