# 🤖 TerraTactician Expandoria Android build-base

You can find the source code of the game [here][game].
Android release builds are available on the [android-release-page][android-releases]
or [on F-Droid][f-droid].

[game]: https://codeberg.org/terratactician-expandoria/game
[android-releases]: https://codeberg.org/terratactician-expandoria/android/releases
[f-droid]: https://f-droid.org/en/packages/page.codeberg.terratactician_expandoria

As of [Bevy 15][bevy-15] the old `cargo-apk` based build-process is deprecated. \
Because our Android support is considered experimental and the new build system
requires an entire gradle project, we've decided to move the package in
a separate repo.

[bevy-15]: https://bevyengine.org/news/bevy-0-15/#android-configurable-gameactivity-and-nativeactivity

## Building

First of all, simply clone the following repo, using the following command to
automatically checkout the submodule:
```sh
git clone --recursive https://codeberg.org/terratactician-expandoria/android
```

To be able to build the android version, you have to install `java` set up the
Android SDK and install `cargo-ndk`. \
Alternatively, you can build our utility container, which automatically sets up
all dependencies:
`docker build -t rust-android-utils .`.
Afterwards, you can simply call `docker run -v ./:/work -it rust-android-utils`
and navigate into `/work`.

The entire build process in integrated into the gradle config.
Simply execute the following command to build the APK.
Once the command succeeds, the apk can be found here:
`app/build/outputs/apk/release/app-release-unsigned.apk`.
```sh
# debug build
./gradlew build
# release build
./gradlew assembleRelease
```

You can use the following commands to *align* and *sign* the APK:
```sh
/opt/android-sdk/build-tools/34.0.0/zipalign -v -p 4 app/build/outputs/apk/release/app-release-unsigned.apk app-aligned.apk
/opt/android-sdk/build-tools/34.0.0/apksigner sign --ks tte-android.keystore --out signed.apk app-aligned.apk
```
