extends RigidBody2D


# Declare member variables here. Examples:
# var a = 2
# var b = "text"


# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
#func _process(delta):
#	pass

var level_splats = [preload("res://assets/sprites/objects/splat_level1.png"), preload("res://assets/sprites/objects/splat_level2.png")]
var splat_sound = preload("res://assets/audio/effects/splat.ogg")

func _on_Seed_body_entered(body):
	if body.name.begins_with("LevelA") or body.name.begins_with("@LevelA@"):
		var splat = Sprite.new()
		splat.texture = level_splats[0]
		splat.position = body.global_position
		splat.rotation_degrees = rand_range(-180, 180)
		get_tree().root.get_node("Main/SoundEffects").stream = splat_sound
		get_tree().root.get_node("Main/SoundEffects").stream.loop = false
		get_tree().root.get_node("Main/SoundEffects").play()
		get_tree().root.get_node("Main/Game/BackEffects").add_child(splat)
		body.queue_free()
		queue_free()
	elif body.name.begins_with("LevelB") or body.name.begins_with("@LevelB@"):
		var splat = Sprite.new()
		splat.texture = level_splats[1]
		splat.position = body.global_position
		splat.rotation_degrees = rand_range(-180, 180)
		get_tree().root.get_node("Main/SoundEffects").stream = splat_sound
		get_tree().root.get_node("Main/SoundEffects").stream.loop = false
		get_tree().root.get_node("Main/SoundEffects").play()
		get_tree().root.get_node("Main/Game/BackEffects").add_child(splat)
		body.queue_free()
		queue_free()
