// Migraine Log - a simple multi-platform headache diary
// Copyright (C) 2021    Eskild Hustvedt
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import 'package:intl/intl.dart';

class MLi18nStrings {
  MLi18nStrings._();

  static String dayString(int number) {
    assert(number > 0);
    return Intl.plural(
      number,
      one: "$number day",
      two: "$number days",
      other: "$number days",
      name: 'dayString',
      desc:
          "How many days there are. This isn't as complicated as it looks. Unless you know you need to modify the pluralization rules (in which case see https://pub.dev/documentation/intl/latest/intl/Intl/plural.html) you should just change the string 'day' and 'days' here into your local equivalent. For instance, the Norwegian version of this string is: '{number,plural, =1{{number} dag}=2{{number} dagar}other{{number} dagar}}'. number will always be a positive integer (never zero).",
      args: [number],
    );
  }

  static String timesString(int number) {
    assert(number > 0);
    return Intl.plural(
      number,
      one: "$number time",
      two: "$number times",
      other: "$number times",
      name: 'timesString',
      desc:
          "How many times something happened (ie. how many times a medication was taken). This isn't as complicated as it looks. Unless you know you need to modify the pluralization rules (in which case see https://pub.dev/documentation/intl/latest/intl/Intl/plural.html) you should just change the string 'time' and 'times' here into your local equivalent. For instance, the Norwegian version of this string is: '{number,plural, =1{{number} gang}=2{{number} ganger}other{{number} ganger}}'. number will always be a positive integer (never zero).",
      args: [number],
    );
  }
}
