// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

import 'mixin_break/mixin_break_class1.dart';
import 'mixin_break/mixin_break_class2.dart';
import 'mixin_break/mixin_break_mixin_class.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 30;
// AUTOGENERATED END

const file = 'mixin_break_mixin_class.dart';

int codeRuns = 0;

void code() {
  if (++codeRuns > 1) {
    print('Calling debugger!');
    debugger(); // LINE_A
  }
  final a = Hello1();
  final b = Hello2();
  a.speak();
  b.speak();

  print('Both now compiled');
}

final stops = <String>[];
const expected = <String>[
  '$file:$LINE_B:5 (mixin_break_class1.dart:$LINE_B1:5)',
  '$file:$LINE_B:5 (mixin_break_class2.dart:$LINE_B2:5)',
];

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  setBreakpointAtUriAndLine(file, LINE_B),
  resumeProgramRecordingStops(stops, true),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'mixin_break_test.dart',
      testeeBefore: code,
      testeeConcurrent: code,
      pauseOnStart: false,
      pauseOnExit: true,
    );
