#!/usr/bin/perl
use 5.030;
use feature 'signatures';
no warnings 'experimental::signatures';
use Mojo::DOM;

# Reads a file into a scalar and returns it
sub slurp ($file) {
    open( my $in, '<', $file ) or die("Failed to open $file for reading: $!");
    local $/ = undef;
    my $content = <$in>;
    close($in);
    return $content;
}

sub getCSS () {
    my $file      = slurp('./lib/exporter.dart');
    my $seenStyle = 0;
    my @css;
    foreach my $line ( split( "\n", $file ) ) {
        if ( index( $line, '<style type="text/css">' ) != -1 ) {
            $seenStyle = 1;
            next;
        }
        if ( index( $line, '</style>' ) != -1 ) {
            last;
        }
        if ($seenStyle) {
            $line =~ s/^\s+'//;
            $line =~ s/'\s*$//;
            push( @css, $line );
        }
    }
    return join( "", @css );
}

sub main () {
    my $file = shift(@ARGV);
    if ( !defined $file || !-e $file || !-w $file ) {
        die(
"Usage: $0 file.html\n\nWill patch file.html and replace the javascript with ./assets/web.js\nUseful for testing updates to the Migraine Log JS component\n"
        );
    }
    my $newJS = slurp('./assets/web.js');

    my $patchFile = slurp($file);
    my $dom       = Mojo::DOM->new($patchFile);
    use Data::Dumper;
    $dom->find('script[type="text/javascript"]')
      ->first->replace(
        '<script type="text/javascript">' . $newJS . '</script>' );
    $dom->find('style')
      ->first->replace( '<style type="text/css">' . getCSS() . '</style>' );

    open( my $outFile, '>', $file );
    print {$outFile} $dom->to_string;
}

main();
