// SPDX-License-Identifier: GPL-2.0-or-later
// Copyright The XCSoar Project

#include "Airspace.hpp"
#include "AbstractAirspace.hpp"
#include "AirspaceIntersectionVector.hpp"
#include "Atmosphere/Pressure.hpp"

Airspace::Airspace(AirspacePtr _airspace,
                   const FlatProjection &tp) noexcept
  :FlatBoundingBox(_airspace->GetBoundingBox(tp)),
   airspace(std::move(_airspace))
{
}

bool
Airspace::IsInside(const AircraftState &loc) const noexcept
{
  assert(airspace != nullptr);
  return airspace->Inside(loc);
}


bool
Airspace::IsInside(const GeoPoint &loc) const noexcept
{
  assert(airspace != nullptr);
  return airspace->Inside(loc);
}

AirspaceIntersectionVector
Airspace::Intersects(const GeoPoint &g1, const GeoPoint &end,
                     const FlatProjection &projection) const noexcept
{
  assert(airspace != nullptr);
  return airspace->Intersects(g1, end, projection);
}

void
Airspace::SetGroundLevel(const double alt) const noexcept
{
  assert(airspace != nullptr);
  airspace->SetGroundLevel(alt);
}

bool
Airspace::NeedGroundLevel() const noexcept
{
  assert(airspace != nullptr);
  return airspace->NeedGroundLevel();
}

void
Airspace::SetFlightLevel(const AtmosphericPressure press) const noexcept
{
  assert(airspace != nullptr);
  airspace->SetFlightLevel(press);
}

void
Airspace::SetActivity(const AirspaceActivity mask) const noexcept
{
  assert(airspace != nullptr);
  airspace->SetActivity(mask);
}

void
Airspace::ClearClearance() const noexcept
{
  assert(airspace != nullptr);
  airspace->ClearClearance();
}
