/*
 * Copyright (C) 2009-2012 by Matthias Ringwald
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 4. Any redistribution, use, or modification is done solely for
 *    personal benefit and not for any commercial purpose or for
 *    monetary gain.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS RINGWALD AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS
 * RINGWALD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Please inquire about commercial licensing options at btstack@ringwald.ch
 *
 */

/*
 *  btstsack_memory.h
 *
 *  @brief BTstack memory management via configurable memory pools
 *
 *  @note code semi-atuomatically generated by btstack_memory_generator.py
 *
 */

#include "btstack_memory.h"
#include <btstack/memory_pool.h>

#include <stdlib.h>

#include "config.h"
#include "hci.h"
#include "l2cap.h"
#include "rfcomm.h"

// MARK: hci_connection_t
#ifdef MAX_NO_HCI_CONNECTIONS
#if MAX_NO_HCI_CONNECTIONS > 0
static hci_connection_t hci_connection_storage[MAX_NO_HCI_CONNECTIONS];
static memory_pool_t hci_connection_pool;
void * btstack_memory_hci_connection_get(void){
    return memory_pool_get(&hci_connection_pool);
}
void btstack_memory_hci_connection_free(void *hci_connection){
    memory_pool_free(&hci_connection_pool, hci_connection);
}
#else
void * btstack_memory_hci_connection_get(void){
    return NULL;
}
void btstack_memory_hci_connection_free(void *hci_connection){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_hci_connection_get(void){
    return malloc(sizeof(hci_connection_t));
}
void  btstack_memory_hci_connection_free(void *hci_connection){
    free(hci_connection);
}
#else
#error "The struct hci_connection has neither HAVE_MALLOC nor MAX_NO_HCI_CONNECTIONS defined. Please, edit the config file."
#endif


// MARK: l2cap_service_t
#ifdef MAX_NO_L2CAP_SERVICES
#if MAX_NO_L2CAP_SERVICES > 0
static l2cap_service_t l2cap_service_storage[MAX_NO_L2CAP_SERVICES];
static memory_pool_t l2cap_service_pool;
void * btstack_memory_l2cap_service_get(void){
    return memory_pool_get(&l2cap_service_pool);
}
void btstack_memory_l2cap_service_free(void *l2cap_service){
    memory_pool_free(&l2cap_service_pool, l2cap_service);
}
#else
void * btstack_memory_l2cap_service_get(void){
    return NULL;
}
void btstack_memory_l2cap_service_free(void *l2cap_service){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_l2cap_service_get(void){
    return malloc(sizeof(l2cap_service_t));
}
void  btstack_memory_l2cap_service_free(void *l2cap_service){
    free(l2cap_service);
}
#else
#error "The struct l2cap_service has neither HAVE_MALLOC nor MAX_NO_L2CAP_SERVICES defined. Please, edit the config file."
#endif


// MARK: l2cap_channel_t
#ifdef MAX_NO_L2CAP_CHANNELS
#if MAX_NO_L2CAP_CHANNELS > 0
static l2cap_channel_t l2cap_channel_storage[MAX_NO_L2CAP_CHANNELS];
static memory_pool_t l2cap_channel_pool;
void * btstack_memory_l2cap_channel_get(void){
    return memory_pool_get(&l2cap_channel_pool);
}
void btstack_memory_l2cap_channel_free(void *l2cap_channel){
    memory_pool_free(&l2cap_channel_pool, l2cap_channel);
}
#else
void * btstack_memory_l2cap_channel_get(void){
    return NULL;
}
void btstack_memory_l2cap_channel_free(void *l2cap_channel){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_l2cap_channel_get(void){
    return malloc(sizeof(l2cap_channel_t));
}
void  btstack_memory_l2cap_channel_free(void *l2cap_channel){
    free(l2cap_channel);
}
#else
#error "The struct l2cap_channel has neither HAVE_MALLOC nor MAX_NO_L2CAP_CHANNELS defined. Please, edit the config file."
#endif


// MARK: rfcomm_multiplexer_t
#ifdef MAX_NO_RFCOMM_MULTIPLEXERS
#if MAX_NO_RFCOMM_MULTIPLEXERS > 0
static rfcomm_multiplexer_t rfcomm_multiplexer_storage[MAX_NO_RFCOMM_MULTIPLEXERS];
static memory_pool_t rfcomm_multiplexer_pool;
void * btstack_memory_rfcomm_multiplexer_get(void){
    return memory_pool_get(&rfcomm_multiplexer_pool);
}
void btstack_memory_rfcomm_multiplexer_free(void *rfcomm_multiplexer){
    memory_pool_free(&rfcomm_multiplexer_pool, rfcomm_multiplexer);
}
#else
void * btstack_memory_rfcomm_multiplexer_get(void){
    return NULL;
}
void btstack_memory_rfcomm_multiplexer_free(void *rfcomm_multiplexer){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_rfcomm_multiplexer_get(void){
    return malloc(sizeof(rfcomm_multiplexer_t));
}
void  btstack_memory_rfcomm_multiplexer_free(void *rfcomm_multiplexer){
    free(rfcomm_multiplexer);
}
#else
#error "The struct rfcomm_multiplexer has neither HAVE_MALLOC nor MAX_NO_RFCOMM_MULTIPLEXERS defined. Please, edit the config file."
#endif


// MARK: rfcomm_service_t
#ifdef MAX_NO_RFCOMM_SERVICES
#if MAX_NO_RFCOMM_SERVICES > 0
static rfcomm_service_t rfcomm_service_storage[MAX_NO_RFCOMM_SERVICES];
static memory_pool_t rfcomm_service_pool;
void * btstack_memory_rfcomm_service_get(void){
    return memory_pool_get(&rfcomm_service_pool);
}
void btstack_memory_rfcomm_service_free(void *rfcomm_service){
    memory_pool_free(&rfcomm_service_pool, rfcomm_service);
}
#else
void * btstack_memory_rfcomm_service_get(void){
    return NULL;
}
void btstack_memory_rfcomm_service_free(void *rfcomm_service){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_rfcomm_service_get(void){
    return malloc(sizeof(rfcomm_service_t));
}
void  btstack_memory_rfcomm_service_free(void *rfcomm_service){
    free(rfcomm_service);
}
#else
#error "The struct rfcomm_service has neither HAVE_MALLOC nor MAX_NO_RFCOMM_SERVICES defined. Please, edit the config file."
#endif


// MARK: rfcomm_channel_t
#ifdef MAX_NO_RFCOMM_CHANNELS
#if MAX_NO_RFCOMM_CHANNELS > 0
static rfcomm_channel_t rfcomm_channel_storage[MAX_NO_RFCOMM_CHANNELS];
static memory_pool_t rfcomm_channel_pool;
void * btstack_memory_rfcomm_channel_get(void){
    return memory_pool_get(&rfcomm_channel_pool);
}
void btstack_memory_rfcomm_channel_free(void *rfcomm_channel){
    memory_pool_free(&rfcomm_channel_pool, rfcomm_channel);
}
#else
void * btstack_memory_rfcomm_channel_get(void){
    return NULL;
}
void btstack_memory_rfcomm_channel_free(void *rfcomm_channel){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_rfcomm_channel_get(void){
    return malloc(sizeof(rfcomm_channel_t));
}
void  btstack_memory_rfcomm_channel_free(void *rfcomm_channel){
    free(rfcomm_channel);
}
#else
#error "The struct rfcomm_channel has neither HAVE_MALLOC nor MAX_NO_RFCOMM_CHANNELS defined. Please, edit the config file."
#endif


// MARK: db_mem_device_name_t
#ifdef MAX_NO_DB_MEM_DEVICE_NAMES
#if MAX_NO_DB_MEM_DEVICE_NAMES > 0
static db_mem_device_name_t db_mem_device_name_storage[MAX_NO_DB_MEM_DEVICE_NAMES];
static memory_pool_t db_mem_device_name_pool;
void * btstack_memory_db_mem_device_name_get(void){
    return memory_pool_get(&db_mem_device_name_pool);
}
void btstack_memory_db_mem_device_name_free(void *db_mem_device_name){
    memory_pool_free(&db_mem_device_name_pool, db_mem_device_name);
}
#else
void * btstack_memory_db_mem_device_name_get(void){
    return NULL;
}
void btstack_memory_db_mem_device_name_free(void *db_mem_device_name){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_db_mem_device_name_get(void){
    return malloc(sizeof(db_mem_device_name_t));
}
void  btstack_memory_db_mem_device_name_free(void *db_mem_device_name){
    free(db_mem_device_name);
}
#else
#error "The struct db_mem_device_name has neither HAVE_MALLOC nor MAX_NO_DB_MEM_DEVICE_NAMES defined. Please, edit the config file."
#endif


// MARK: db_mem_device_link_key_t
#ifdef MAX_NO_DB_MEM_DEVICE_LINK_KEYS
#if MAX_NO_DB_MEM_DEVICE_LINK_KEYS > 0
static db_mem_device_link_key_t db_mem_device_link_key_storage[MAX_NO_DB_MEM_DEVICE_LINK_KEYS];
static memory_pool_t db_mem_device_link_key_pool;
void * btstack_memory_db_mem_device_link_key_get(void){
    return memory_pool_get(&db_mem_device_link_key_pool);
}
void btstack_memory_db_mem_device_link_key_free(void *db_mem_device_link_key){
    memory_pool_free(&db_mem_device_link_key_pool, db_mem_device_link_key);
}
#else
void * btstack_memory_db_mem_device_link_key_get(void){
    return NULL;
}
void btstack_memory_db_mem_device_link_key_free(void *db_mem_device_link_key){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_db_mem_device_link_key_get(void){
    return malloc(sizeof(db_mem_device_link_key_t));
}
void  btstack_memory_db_mem_device_link_key_free(void *db_mem_device_link_key){
    free(db_mem_device_link_key);
}
#else
#error "The struct db_mem_device_link_key has neither HAVE_MALLOC nor MAX_NO_DB_MEM_DEVICE_LINK_KEYS defined. Please, edit the config file."
#endif


// MARK: db_mem_service_t
#ifdef MAX_NO_DB_MEM_SERVICES
#if MAX_NO_DB_MEM_SERVICES > 0
static db_mem_service_t db_mem_service_storage[MAX_NO_DB_MEM_SERVICES];
static memory_pool_t db_mem_service_pool;
void * btstack_memory_db_mem_service_get(void){
    return memory_pool_get(&db_mem_service_pool);
}
void btstack_memory_db_mem_service_free(void *db_mem_service){
    memory_pool_free(&db_mem_service_pool, db_mem_service);
}
#else
void * btstack_memory_db_mem_service_get(void){
    return NULL;
}
void btstack_memory_db_mem_service_free(void *db_mem_service){
};
#endif
#elif defined(HAVE_MALLOC)
void * btstack_memory_db_mem_service_get(void){
    return malloc(sizeof(db_mem_service_t));
}
void  btstack_memory_db_mem_service_free(void *db_mem_service){
    free(db_mem_service);
}
#else
#error "The struct db_mem_service has neither HAVE_MALLOC nor MAX_NO_DB_MEM_SERVICES defined. Please, edit the config file."
#endif

// init
void btstack_memory_init(void){
#if MAX_NO_HCI_CONNECTIONS > 0
    memory_pool_create(&hci_connection_pool, hci_connection_storage, MAX_NO_HCI_CONNECTIONS, sizeof(hci_connection_t));
#endif
#if MAX_NO_L2CAP_SERVICES > 0
    memory_pool_create(&l2cap_service_pool, l2cap_service_storage, MAX_NO_L2CAP_SERVICES, sizeof(l2cap_service_t));
#endif
#if MAX_NO_L2CAP_CHANNELS > 0
    memory_pool_create(&l2cap_channel_pool, l2cap_channel_storage, MAX_NO_L2CAP_CHANNELS, sizeof(l2cap_channel_t));
#endif
#if MAX_NO_RFCOMM_MULTIPLEXERS > 0
    memory_pool_create(&rfcomm_multiplexer_pool, rfcomm_multiplexer_storage, MAX_NO_RFCOMM_MULTIPLEXERS, sizeof(rfcomm_multiplexer_t));
#endif
#if MAX_NO_RFCOMM_SERVICES > 0
    memory_pool_create(&rfcomm_service_pool, rfcomm_service_storage, MAX_NO_RFCOMM_SERVICES, sizeof(rfcomm_service_t));
#endif
#if MAX_NO_RFCOMM_CHANNELS > 0
    memory_pool_create(&rfcomm_channel_pool, rfcomm_channel_storage, MAX_NO_RFCOMM_CHANNELS, sizeof(rfcomm_channel_t));
#endif
#if MAX_NO_DB_MEM_DEVICE_NAMES > 0
    memory_pool_create(&db_mem_device_name_pool, db_mem_device_name_storage, MAX_NO_DB_MEM_DEVICE_NAMES, sizeof(db_mem_device_name_t));
#endif
#if MAX_NO_DB_MEM_DEVICE_LINK_KEYS > 0
    memory_pool_create(&db_mem_device_link_key_pool, db_mem_device_link_key_storage, MAX_NO_DB_MEM_DEVICE_LINK_KEYS, sizeof(db_mem_device_link_key_t));
#endif
#if MAX_NO_DB_MEM_SERVICES > 0
    memory_pool_create(&db_mem_service_pool, db_mem_service_storage, MAX_NO_DB_MEM_SERVICES, sizeof(db_mem_service_t));
#endif
}

