package ioio.examples.simple;

import ioio.lib.api.AnalogInput;
import ioio.lib.api.DigitalOutput;
import ioio.lib.api.IOIO;
import ioio.lib.api.PwmOutput;
import ioio.lib.api.exception.ConnectionLostException;
import ioio.lib.util.BaseIOIOLooper;
import ioio.lib.util.IOIOLooper;
import ioio.lib.util.android.IOIOActivity;

import android.os.Bundle;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.ToggleButton;

public class IOIOSimpleApp extends IOIOActivity {
    private TextView textView_;
    private SeekBar seekBar_;
    private ToggleButton toggleButton_;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        textView_ = findViewById(R.id.TextView);
        seekBar_ = findViewById(R.id.SeekBar);
        toggleButton_ = findViewById(R.id.ToggleButton);

        enableUi(false);
    }

    @Override
    protected IOIOLooper createIOIOLooper() {
        return new Looper();
    }

    private void enableUi(final boolean enable) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                seekBar_.setEnabled(enable);
                toggleButton_.setEnabled(enable);
            }
        });
    }

    private void setNumber(float f) {
        final String str = String.format("%.2f", f);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                textView_.setText(str);
            }
        });
    }

    class Looper extends BaseIOIOLooper {
        private AnalogInput input_;
        private PwmOutput pwmOutput_;
        private DigitalOutput led_;

        @Override
        public void setup() throws ConnectionLostException {
            led_ = ioio_.openDigitalOutput(IOIO.LED_PIN, true);
            input_ = ioio_.openAnalogInput(40);
            pwmOutput_ = ioio_.openPwmOutput(12, 100);
            enableUi(true);
        }

        @Override
        public void loop() throws ConnectionLostException, InterruptedException {
            setNumber(input_.read());
            pwmOutput_.setPulseWidth(500 + seekBar_.getProgress() * 2);
            led_.write(!toggleButton_.isChecked());
            Thread.sleep(10);
        }

        @Override
        public void disconnected() {
            enableUi(false);
        }
    }
}