/*****************************************************************************
 * log.h
 *****************************************************************************
 * Copyright © 2011-2012 VLC authors and VideoLAN
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifndef LIBVLCJNI_LOG_H
#define LIBVLCJNI_LOG_H

#include <android/log.h>
#include <medialibrary/ILogger.h>

/* C files should define LOG_TAG before including this header */
#ifndef LOG_TAG
# error You must define LOG_TAG
#endif

#ifndef NDEBUG
# define LOGD(...)  __android_log_print(ANDROID_LOG_DEBUG,LOG_TAG,__VA_ARGS__)
# define LOGV(...)  __android_log_print(ANDROID_LOG_VERBOSE,LOG_TAG,__VA_ARGS__)
#else
# define LOGD(...)  (void)0
# define LOGV(...)  (void)0
#endif
#define  LOGI(...)  __android_log_print(ANDROID_LOG_INFO,LOG_TAG,__VA_ARGS__)
#define  LOGE(...)  __android_log_print(ANDROID_LOG_ERROR,LOG_TAG,__VA_ARGS__)
#define  LOGW(...)  __android_log_print(ANDROID_LOG_WARNING,LOG_TAG,__VA_ARGS__)

class AndroidMediaLibraryLogger : public medialibrary::ILogger
{
    virtual void Error( const std::string& msg ) override
    {
        __android_log_print( ANDROID_LOG_ERROR, "VLC/medialibrary", "%s", msg.c_str() );
    }

    virtual void Warning( const std::string& msg ) override
    {
        __android_log_print( ANDROID_LOG_WARN, "VLC/medialibrary", "%s", msg.c_str() );
    }

    virtual void Info( const std::string& msg ) override
    {
        __android_log_print( ANDROID_LOG_INFO, "VLC/medialibrary", "%s", msg.c_str() );
    }

    virtual void Debug( const std::string& msg ) override
    {
        __android_log_print( ANDROID_LOG_DEBUG, "VLC/medialibrary", "%s", msg.c_str() );
    }

    virtual void Verbose( const std::string& msg ) override
    {
        __android_log_print( ANDROID_LOG_VERBOSE, "VLC/medialibrary", "%s", msg.c_str() );
    }
};

#endif // LIBVLCJNI_LOG_H
