#!/bin/bash -e

[ $# -ne 1 ] && echo "Usage: $0 {version}" && exit 1

VERSION="$1"

[ -f "$VERSION.aab" ] || curl -o "$VERSION.aab" --follow "https://codeberg.org/NextPush/nextpush-android/releases/download/$VERSION/nextpush.aab"

pass ls | grep nextpush.key >/dev/null
if [ $? -ne 0 ]; then
  echo "Pass keystore/nextpush.key not found. Aborting."
  exit 1
fi

export KS="$HOME/.password-store/keystore/nextpush.jks"
export KS_PASS=$(pass keystore/nextpush.key)
export KEY_ALIAS="nextpush"
export AAB="$VERSION.aab"

echo "[+] Pass copied"

./gradlew bundletoolBuildApks

unzip -o universal.apks
mv universal.apk nextpush.apk
mv app.apks nextpush.apks
echo "[+] Done"
