# Notification Channel Examples
Here are some examples on how to set up Notification channels for some services. \
These are only examples so feel free to edit them and play with them to your hearts content. 

## Testing

If you'd like to test your Notification channel, simply open a terminal and run this command. \
Remember to replace the placeholders with the Notification channel endpoint you get by longpressing.

`curl {Replace_with_Notification_channel_endpoint} -d "Hello world! This is a test."`

How it should look:

<img src="test_example.png" alt="An Android screenshot showcasing a NextPush notification test" style="width:50px;">

## SSH & Local Logins

With your favorite text editor, open `/etc/profile` as root and add the following text to the very bottom of the file. \
Remember to replace the placeholders with the Notification channel endpoint you get by longpressing.

```
if [ -n "$SSH_CLIENT" ]; then
curl {Replace_with_Notification_channel_endpoint} -d "${USER}@$(hostname -f) has logged in via SSH." > /dev/null
else
curl {Replace_with_Notification_channel_endpoint} -d "${USER}@$(hostname -f) has logged in locally." > /dev/null
fi
```

How it should look:

<img src="ssh_example.png" alt="An Android screenshot showcasing a NextPush SSH Login notification" style="width:50px;">

## DIUN
[DIUN Project Documentation](https://github.com/crazy-max/diun) \
To get notified with DIUN, you will need to create a file and mount that file to your diun docker container. \
This example creates a file named `cmd.sh`, and mounts it at `/etc/diun/etc.sh`

With your favorite text editor, create and open `cmd.sh`, then paste this text. \
Remember to replace the placeholders with the Notification channel endpoint you get by longpressing.


```
#!/bin/sh

env > /etc/diun/output
apk add curl
if [ "${DIUN_ENTRY_STATUS}" -ne "new" ]; then
    return 0
fi
curl {Replace_with_Notification_channel_endpoint}  -d 'There is a Docker Image update available.' 
```

Afterwards, mark `cmd.sh` as executable: `chmod +x ./cmd.sh`

Finally add this to your DIUN config under `notif:`

```
  script:
    cmd: "sh"
    args:
      - '-c'
      - '/etc/diun/cmd.sh'
```

Now when DIUN runs you should get a notification that looks like this:

<img src="diun_example.png" alt="An Android screenshot showcasing a NextPush DIUN notification" style="width:50px;">

> Note: I'm not entirely versed in DIUN configuration and I know there is some way to let it tell you which container needs to be updated. Pull requests to fix this feature would be helpful!

## Home Assistant
[Home Assistant Documentation](https://www.home-assistant.io/docs/)
To get Notifications from Home Assistant, we will be using the RESTful Notifications service built into Home Assistant.\
With your favorite text editor, open your HA `configuration.yaml` and add the following text to the bottom of the file \
Remember to replace the placeholders with the Notification channel endpoint you get by longpressing.

```
rest_command:
 notify_nextpush:
   url: '{Replace_with_Notification_channel_endpoint}'
   method: post
   payload: '{{ message }}'
```

Reload your HA configuration, go to Settings > Automations & Scenes > + Creation Automation > Create new automation > Then do + Add action > Search for "RESTful Command: notify_nextpush" > Three dot menu in top right of RESTful command > Edit in YAML, and add a message that's relavent to the notification you'd like to recieve, and remember to add a When trigger.
```
service: rest_command.notify_nextpush
metadata: {}
data:
  message: Motion detected at the front door.
  ```

  How it should look:
  
<img src="ha_example.png" alt="An Android screenshot showcasing a NextPush Home Assistant notification test" style="width:50px;">

  ## The end!

  If there are more examples that you feel may be useful to add to these examples, feel free to submit a pull request!