package org.unifiedpush.distributor.nextpush.utils

import android.os.Build
import okhttp3.OkHttpClient
import org.unifiedpush.distributor.nextpush.BuildConfig

object NextPushHttpClient {
    val ua = "NextPush/${BuildConfig.VERSION_NAME} (${BuildConfig.VERSION_CODE}; Android ${Build.VERSION.RELEASE})"
    fun Builder(): OkHttpClient.Builder = OkHttpClient.Builder()
        .addNetworkInterceptor { chain ->
            chain.proceed(
                chain
                    .request()
                    .newBuilder()
                    .header("User-Agent", ua)
                    .build()
            )
        }
}
