package org.unifiedpush.distributor.nextpush.services

import android.content.Context
import okhttp3.Request
import okhttp3.sse.EventSource
import org.unifiedpush.distributor.AppNotification
import org.unifiedpush.distributor.SourceManager as SManager
import org.unifiedpush.distributor.nextpush.utils.DisconnectedNotification
import org.unifiedpush.distributor.nextpush.utils.NoPingNotification

object SourceManager : SManager<EventSource>() {
    override val foregroundService = StartService.service
    override val migrationManager = MigrationManager()

    override fun getDummySource(): EventSource = object : EventSource {
        override fun cancel() {}
        override fun request(): Request = Request.Builder().build()
    }

    override fun cancelSource(source: EventSource?) {
        source?.cancel()
    }

    override fun noPingNotification(context: Context): AppNotification? = NoPingNotification(context)

    override fun disconnectedNotification(context: Context): AppNotification? = DisconnectedNotification(context)
}
