@file:Suppress("ktlint:standard:no-wildcard-imports")

package org.unifiedpush.distributor.nextpush.receivers

import android.content.Context
import org.unifiedpush.distributor.nextpush.AppStore
import org.unifiedpush.distributor.nextpush.Distributor
import org.unifiedpush.distributor.nextpush.account.AccountFactory
import org.unifiedpush.distributor.nextpush.callback.NetworkCallbackFactory
import org.unifiedpush.distributor.receiver.DistributorReceiver

/**
 * THIS SERVICE IS USED BY OTHER APPS TO REGISTER
 */
class RegisterBroadcastReceiver : DistributorReceiver() {

    override val distributor = Distributor

    override fun isConnected(context: Context): Boolean = AccountFactory.getAccount(context)?.connected == true

    override fun hasInternet(context: Context): Boolean = NetworkCallbackFactory.hasInternet()

    override fun showToasts(context: Context): Boolean = AppStore(context).showToasts
}
