package org.unifiedpush.distributor.nextpush.callback

import android.content.Context
import org.unifiedpush.distributor.callback.CallbackFactory
import org.unifiedpush.distributor.callback.NetworkCallback
import org.unifiedpush.distributor.nextpush.services.MainRegistrationCounter
import org.unifiedpush.distributor.nextpush.services.RestartWorker
import org.unifiedpush.distributor.nextpush.services.SourceManager

object NetworkCallbackFactory : CallbackFactory<NetworkCallbackFactory.MainNetworkCallback>() {
    class MainNetworkCallback(val context: Context) : NetworkCallback() {
        override val sourceManager = SourceManager
        override val registrationCounter = MainRegistrationCounter
        override val worker = RestartWorker.Companion
    }

    override fun new(context: Context): MainNetworkCallback = MainNetworkCallback(context)

    /**
     * Consider there is internet until the network callback is registered
     */
    fun hasInternet(): Boolean = instance?.hasInternet() ?: true
}
