package org.unifiedpush.distributor.nextpush.api.provider

import android.content.Context
import android.util.Log
import com.google.gson.GsonBuilder
import com.nextcloud.android.sso.api.NextcloudAPI
import org.unifiedpush.distributor.nextpush.account.AccountFactory
import org.unifiedpush.distributor.nextpush.account.SSOAccount
import retrofit2.NextcloudRetrofitApiBuilder

class ApiSSOFactory(val context: Context) : ApiProviderFactory {
    override fun getProviderAndExecute(block: (ApiProvider, then: () -> Unit) -> Unit) {
        var nextcloudAPI: NextcloudAPI? = null
        val account = AccountFactory.getAccount(context) ?: run {
            throw NoProviderException("No account found")
        }
        val client = (account as SSOAccount).getClient(context) ?: run {
            throw NoProviderException("No client found")
        }
        val ssoApiCallback = object : NextcloudAPI.ApiConnectedListener {
            override fun onConnected() {
                Log.d(TAG, "Api connected.")
                nextcloudAPI?.let { nextcloudAPI ->
                    NextcloudRetrofitApiBuilder(nextcloudAPI, ApiProvider.API_PATH)
                        .create(ApiProvider::class.java).let {
                            block(it) {
                                nextcloudAPI.close()
                            }
                        }
                }
            }

            override fun onError(ex: Exception) {
                Log.d(TAG, "Cannot connect to API: ex = [$ex]")
            }
        }
        nextcloudAPI = NextcloudAPI(
            context,
            client,
            GsonBuilder().create(),
            ssoApiCallback
        )
    }

    companion object {
        private const val TAG = "ApiSSOFactory"
    }
}
