package org.unifiedpush.distributor.nextpush.api.provider

import android.content.Context
import org.unifiedpush.distributor.nextpush.account.AccountFactory
import org.unifiedpush.distributor.nextpush.account.DirectAccount
import org.unifiedpush.distributor.nextpush.api.provider.ApiProvider.Companion.API_PATH
import retrofit2.Retrofit
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory
import retrofit2.converter.gson.GsonConverterFactory

class ApiDirectFactory(val context: Context) : ApiProviderFactory {
    override fun getProviderAndExecute(block: (ApiProvider, then: () -> Unit) -> Unit) {
        val account = AccountFactory.getAccount(context) ?: run {
            throw NoProviderException("No account found")
        }
        val url = account.url ?: run {
            throw NoProviderException("No url found")
        }
        val client = (account as DirectAccount).getClient(context) ?: run {
            throw NoProviderException("No client found")
        }
        Retrofit.Builder()
            .client(client)
            .addConverterFactory(GsonConverterFactory.create())
            .addCallAdapterFactory(RxJava3CallAdapterFactory.create())
            .baseUrl("$url$API_PATH").build()
            .create(ApiProvider::class.java).let {
                block(it) {}
            }
    }
}
