package org.unifiedpush.distributor.nextpush.activities.ui

import android.content.Context
import org.unifiedpush.distributor.nextpush.AppStore
import org.unifiedpush.distributor.nextpush.account.AccountFactory

data class MainUiState(
    val accountName: String,
    val showDebugInfo: Boolean = false,
    val showToasts: Boolean = false
) {
    constructor(context: Context) : this(
        accountName = AccountFactory.getAccount(context)?.name ?: "",
        showToasts = AppStore(context).showToasts
    )
}
