package org.unifiedpush.distributor.nextpush.activities

import android.app.Application
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.launch
import org.unifiedpush.distributor.nextpush.account.AccountFactory

class LoginViewModel(connected: Boolean, val onLogin: () -> Unit = {}) : ViewModel() {
    constructor(application: Application, onLogin: () -> Unit) : this (
        AccountFactory.getAccount(application)?.connected == true,
        onLogin
    )
    var connected by mutableStateOf(connected)

    fun login() {
        viewModelScope.launch {
            connected = true
        }
    }

    fun logout() {
        viewModelScope.launch {
            publishAction(
                AppAction(AppAction.Type.Logout)
            )
            connected = false
        }
    }
}
