package org.unifiedpush.distributor.nextpush.activities

import android.app.Application
import android.content.Context
import org.unifiedpush.android.distributor.ui.compose.DistribMigrationViewModel
import org.unifiedpush.android.distributor.ui.compose.state.DistribMigrationState
import org.unifiedpush.distributor.nextpush.AppStore
import org.unifiedpush.distributor.nextpush.BuildConfig
import org.unifiedpush.distributor.utils.listOtherDistributors

class DistribMigrationViewModel(state: DistribMigrationState, val application: Application? = null) : DistribMigrationViewModel(state) {
    constructor(application: Application) : this(
        stateFrom(application),
        application
    )

    override fun onFallbackDistribSelected(distributor: String?) {
        publishAction(
            AppAction(AppAction.Type.FallbackDistribSelected(distributor))
        )
    }

    override fun onMigrationDistributorSelected(distributor: String) {
        publishAction(
            AppAction(AppAction.Type.MigrateToDistrib(distributor))
        )
    }

    override fun onFallbackIntroShown() {
        publishAction(
            AppAction(AppAction.Type.FallbackIntroShown)
        )
    }

    override fun onServiceReactivated() {
        publishAction(
            AppAction(AppAction.Type.ReactivateUnifiedPush)
        )
    }
    override fun refreshDistributors() {
        application?.let { context ->
            refreshDistributors {
                val store = AppStore(context)
                val fallbackDistrib = store.fallbackService
                return@refreshDistributors context.listOtherDistributors()
                    .map { packageName ->
                        context.applicationRowState(packageName).copy(
                            selected = fallbackDistrib == packageName
                        )
                    }.toSet()
            }
        }
    }

    companion object {
        fun stateFrom(context: Context): DistribMigrationState {
            val store = AppStore(context)
            val fallbackDistrib = store.fallbackService
            val distributors = context.listOtherDistributors().map { packageName ->
                context.applicationRowState(packageName).copy(
                    selected = fallbackDistrib == packageName
                )
            }.toSet()
            val migrated = store.migrated
            return DistribMigrationState(
                distributors,
                store.fallbackIntroShown,
                migrated = migrated,
                featureEnabled = BuildConfig.SUPPORT_MIGRATIONS
            )
        }
    }
}
