package org.unifiedpush.distributor.nextpush.activities

import android.content.Context
import org.unifiedpush.android.distributor.ui.compose.state.ApplicationRowState
import org.unifiedpush.distributor.Database
import org.unifiedpush.distributor.nextpush.R
import org.unifiedpush.distributor.utils.appInfoForMetadata
import org.unifiedpush.distributor.utils.getApplicationIcon
import org.unifiedpush.distributor.utils.getApplicationName

fun Context.applicationRowState(app: Database.App): ApplicationRowState = applicationRowState(app.packageName, app.title, app.description)

fun Context.applicationRowState(
    packageName: String,
    title: String? = null,
    description: String? = null
): ApplicationRowState {
    val ai = appInfoForMetadata(packageName)
    val title = title ?: ai?.let { getApplicationName(it) } ?: packageName
    val icon = getApplicationIcon(packageName)
    val description = if (title == packageName) {
        description ?: ""
    } else {
        description?.let { "$it — $packageName" }
            ?: packageName
    }
    return ApplicationRowState(
        icon = icon,
        title = title,
        packageName = packageName,
        description = description
    )
}

fun Context.localApplicationRowState(app: Database.App): ApplicationRowState {
    val title = app.title ?: "-"
    val icon = getApplicationIcon(app.packageName)
    val description = getString(R.string.list_registrations_local_description)
    return ApplicationRowState(
        icon = icon,
        title = title,
        packageName = app.packageName,
        description = description
    )
}
