package org.unifiedpush.distributor.nextpush.account

import android.content.Context
import org.unifiedpush.distributor.Store
import org.unifiedpush.distributor.nextpush.AppStore

/**
 * Manager SharedPreferences for Account related values
 */
open class AccountStore(context: Context) : Store(context, AppStore.PREF_NAME) {
    var accountType: AccountType
        get() = sharedPreferences
            .getInt(PREF_ACCOUNT_TYPE, 0).toAccountType()
        set(value) = sharedPreferences
            .edit().putInt(PREF_ACCOUNT_TYPE, value.toInt())
            .apply()

    override fun wipe() {
        // Nothing important to do yet
    }

    companion object {
        private const val PREF_ACCOUNT_TYPE = "account::type"
    }
}
