package org.unifiedpush.distributor.nextpush

import android.app.NotificationManager
import android.content.Context
import android.os.Build
import androidx.annotation.RequiresApi
import org.unifiedpush.distributor.MigrationFactory

class Migrations(context: Context) : MigrationFactory(context, AppStore.PREF_NAME) {

    override val migrations = listOf(
        Migration020001
    )

    /**
     * Migration from 0.x.x to 2.0.1
     */
    object Migration020001 : Migration {
        override val version = 20001
        override fun run(context: Context) {
            addEndpointsToDb(context)
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                removeOldOsNotificationChannel(context)
            }
        }

        /**
         * Add endpoints to the db
         */
        private fun addEndpointsToDb(context: Context) {
            val db = DatabaseFactory.getDb(context)
            db.listApps().forEach { app ->
                val chanId = db.getChannelId(app.connectorToken) ?: return@forEach
                val endpoint = Distributor.channelIdToEndpoint(context, chanId)
                db.saveEndpoint(chanId, endpoint)
            }
        }

        /**
         * Migration to remove old notifications channel, they will be recreated
         * once a notification arrives. We didn't remove channel Id when app were
         * deleted. In the same time, we changed the channel ID: they were using
         * the app name, and we move to packageId
         */
        @RequiresApi(Build.VERSION_CODES.O)
        private fun removeOldOsNotificationChannel(context: Context) {
            val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            val oldPrefix = context.getString(R.string.app_name)
            notificationManager.notificationChannels.forEach {
                if (it.id.startsWith(oldPrefix)) {
                    notificationManager.deleteNotificationChannel(it.id)
                }
            }
        }
    }
}
