package org.unifiedpush.distributor.nextpush

import android.app.NotificationManager
import android.content.Context
import android.os.Build
import androidx.annotation.RequiresApi
import java.util.UUID
import org.unifiedpush.distributor.nextpush.activities.UiAction
import org.unifiedpush.distributor.nextpush.utils.FromPushNotification

object LocalNotification {
    fun createChannel(context: Context, title: String) {
        Distributor.createApp(
            context = context,
            packageName = context.packageName,
            connectorToken = UUID.randomUUID().toString(),
            title = title,
            vapid = null,
            description = null
        )
    }

    fun newChannelSucceeded() {
        UiAction.publish(UiAction.Type.RefreshRegistrations)
    }

    fun showNotification(
        context: Context,
        title: String?,
        content: String
    ) {
        val title = title ?: context.getString(R.string.app_name)
        FromPushNotification(context, title, content).showBig()
    }

    /**
     * Remove the notification channel registered to the OS
     */
    @RequiresApi(Build.VERSION_CODES.O)
    fun removeOsNotificationChannel(context: Context, title: String?) {
        val title = title ?: ""
        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        notificationManager.deleteNotificationChannel(
            getNotificationChannelId(context, title)
        )
    }

    fun getNotificationChannelId(context: Context, title: String): String = "${context.packageName}.Push.$title"
}
