package org.unifiedpush.distributor.nextpush

class LastEventId(private val store: AppStore) {

    fun save(id: String) {
        when {
            id.startsWith("high.") -> store.lastHighEventId = id
            id.startsWith("normal.") -> store.lastNormalEventId = id
            id.startsWith("low.") -> store.lastLowEventId = id
            id.startsWith("very-low.") -> store.lastVeryLowEventId = id
        }
    }

    fun get(): String? = arrayOf(
        store.lastHighEventId,
        store.lastNormalEventId,
        store.lastLowEventId,
        store.lastVeryLowEventId
    ).filterNotNull().let {
        if (it.isEmpty()) {
            null
        } else {
            it.joinToString(",")
        }
    }
}
