package org.unifiedpush.distributor.nextpush

import android.content.Context
import androidx.core.content.edit
import org.unifiedpush.distributor.MigrationManager
import org.unifiedpush.distributor.Store
import org.unifiedpush.distributor.nextpush.account.AccountStore

class AppStore(context: Context) :
    Store(context, PREF_NAME),
    MigrationManager.MigrationStore {
    val account = AccountStore(context)

    var deviceId: String?
        get() = sharedPreferences
            .getString(PREF_DEVICE_ID, null)
        set(value) = sharedPreferences
            .edit {
                putOrRemove(PREF_DEVICE_ID, value)
            }

    var lastHighEventId: String?
        get() = sharedPreferences
            .getString(PREF_LAST_EVENT_ID_HIGH, null)
        set(value) = sharedPreferences
            .edit {
                putOrRemove(PREF_LAST_EVENT_ID_HIGH, value)
            }

    var lastNormalEventId: String?
        get() = sharedPreferences
            .getString(PREF_LAST_EVENT_ID_NORMAL, null)
        set(value) = sharedPreferences
            .edit {
                putOrRemove(PREF_LAST_EVENT_ID_NORMAL, value)
            }

    var lastLowEventId: String?
        get() = sharedPreferences
            .getString(PREF_LAST_EVENT_ID_LOW, null)
        set(value) = sharedPreferences
            .edit {
                putOrRemove(PREF_LAST_EVENT_ID_LOW, value)
            }

    var lastVeryLowEventId: String?
        get() = sharedPreferences
            .getString(PREF_LAST_EVENT_ID_VERY_LOW, null)
        set(value) = sharedPreferences
            .edit {
                putOrRemove(PREF_LAST_EVENT_ID_VERY_LOW, value)
            }

    override var fallbackIntroShown: Boolean
        get() = sharedPreferences
            .getBoolean(PREF_FALLBACK_INTRO_SHOWN, false)
        set(value) = sharedPreferences
            .edit {
                putBoolean(PREF_FALLBACK_INTRO_SHOWN, value)
            }

    override var fallbackService: String?
        get() = sharedPreferences
            .getString(PREF_FALLBACK_SERVICE, null)
        set(value) = sharedPreferences
            .edit {
                putOrRemove(PREF_FALLBACK_SERVICE, value)
            }

    /**
     * Whether the registrations have been migrated to another app by the user
     */
    override var migrated: Boolean
        get() = sharedPreferences
            .getBoolean(PREF_MIGRATED, false)
        set(value) = sharedPreferences
            .edit {
                putBoolean(PREF_MIGRATED, value)
            }

    override var tempMigrated: Boolean
        get() = sharedPreferences
            .getBoolean(PREF_TEMP_MIGRATED, false)
        set(value) = sharedPreferences
            .edit {
                putBoolean(PREF_TEMP_MIGRATED, value)
            }

    var dynamicColors: Boolean
        get() = sharedPreferences
            .getBoolean(PREF_DYNAMIC_COLORS, false)
        set(value) = sharedPreferences
            .edit {
                putBoolean(PREF_DYNAMIC_COLORS, value)
            }

    /**
     * Show toasts when a new app is registered or an error occurred
     */
    var showToasts: Boolean
        get() = sharedPreferences
            .getBoolean(PREF_SHOW_TOASTS, false)
        set(value) = sharedPreferences
            .edit {
                putBoolean(PREF_SHOW_TOASTS, value)
            }

    override fun wipe() {
        deviceId = null
        lastHighEventId = null
        lastNormalEventId = null
        lastLowEventId = null
        lastVeryLowEventId = null
        account.wipe()
    }

    companion object {
        internal const val PREF_NAME = "NextPush"
        private const val PREF_DEVICE_ID = "deviceId"
        private const val PREF_LAST_EVENT_ID_HIGH = "lastEventId.high"
        private const val PREF_LAST_EVENT_ID_NORMAL = "lastEventId.normal"
        private const val PREF_LAST_EVENT_ID_LOW = "lastEventId.low"
        private const val PREF_LAST_EVENT_ID_VERY_LOW = "lastEventId.very-low"
        private const val PREF_FALLBACK_INTRO_SHOWN = "fallback_intro_shown"
        private const val PREF_FALLBACK_SERVICE = "fallback_service"
        private const val PREF_MIGRATED = "migrated"
        private const val PREF_TEMP_MIGRATED = "temp_migrated"
        private const val PREF_DYNAMIC_COLORS = "dynamic_colors"
        private const val PREF_SHOW_TOASTS = "show_toasts"
    }
}
