package org.unifiedpush.distributor.nextpush.utils

import java.text.SimpleDateFormat
import org.unifiedpush.distributor.nextpush.AppCompanion
import org.unifiedpush.distributor.nextpush.services.SourceManager
import org.unifiedpush.distributor.nextpush.services.StartService

fun getDebugInfo(): String {
    val date = AppCompanion.lastEventDate?.let {
        SimpleDateFormat.getDateTimeInstance().format(it.time)
    } ?: "None"
    return "ServiceStarted: ${StartService.isServiceStarted()}\n" +
        "Last Event: $date\n" +
        "Keepalive: ${AppCompanion.keepalive.get()}\n" +
        SourceManager.getDebugInfo()
}
