package org.unifiedpush.distributor.nextpush.services

import android.content.Context
import android.util.Log
import java.util.concurrent.atomic.AtomicReference
import org.unifiedpush.distributor.nextpush.AppCompanion
import org.unifiedpush.distributor.nextpush.account.AccountFactory.getAccount
import org.unifiedpush.distributor.nextpush.api.Api
import org.unifiedpush.distributor.nextpush.callback.BatteryCallbackFactory
import org.unifiedpush.distributor.nextpush.callback.NetworkCallbackFactory
import org.unifiedpush.distributor.nextpush.utils.ForegroundNotification
import org.unifiedpush.distributor.nextpush.utils.NOTIFICATION_ID_FOREGROUND
import org.unifiedpush.distributor.nextpush.utils.TAG
import org.unifiedpush.distributor.service.ForegroundService
import org.unifiedpush.distributor.service.ForegroundServiceFactory

class StartService : ForegroundService() {

    override val networkCallbackFactory = NetworkCallbackFactory
    override val batteryCallbackFactory = BatteryCallbackFactory
    override val registrationCounter = MainRegistrationCounter
    override val workerCompanion = RestartWorker.Companion
    override val staticRef = service

    override fun startForegroundNotification() {
        val notification = ForegroundNotification(this).create()
        startForeground(NOTIFICATION_ID_FOREGROUND, notification)
    }

    override fun shouldAbortNewSync(): Boolean = SourceManager.isRunningWithoutFailure

    override fun isConnected(): Boolean = getAccount(this) != null

    override fun sync(releaseLock: () -> Unit) {
        api = Api(this).also {
            it.apiSync(releaseLock)
        }
    }

    override fun destroyServiceResources() {
        api?.apiDestroy()
    }

    private var api: Api? = null

    companion object : ForegroundServiceFactory {
        override val serviceClass = StartService::class.java
        override val service = AtomicReference<ForegroundService?>(null)

        override fun startService(context: Context) {
            Log.d(TAG, "nFails: ${SourceManager.nFails}")
            super.startService(context)
        }

        override fun stopService(block: () -> Unit) {
            AppCompanion.bufferedResponseChecked.set(false)
            AppCompanion.lastEventDate = null
            super.stopService(block)
        }
    }
}
