package org.unifiedpush.distributor.nextpush.services

import android.content.Context
import org.unifiedpush.distributor.Database
import org.unifiedpush.distributor.RegistrationCounter
import org.unifiedpush.distributor.nextpush.DatabaseFactory
import org.unifiedpush.distributor.nextpush.activities.UiAction
import org.unifiedpush.distributor.nextpush.utils.ForegroundNotification

object MainRegistrationCounter : RegistrationCounter() {

    override val workerCompanion = RestartWorker.Companion

    override fun hasManyFails(): Boolean = SourceManager.nFails > 1

    override fun onCountRefreshed(context: Context) {
        ForegroundNotification(context).update()
        UiAction.publish(UiAction.Type.RefreshRegistrations)
    }

    override fun getDb(context: Context): Database = DatabaseFactory.getDb(context)
}
