package org.unifiedpush.distributor.nextpush.callback

import android.content.Context
import java.util.concurrent.atomic.AtomicBoolean
import org.unifiedpush.distributor.callback.BatteryCallback
import org.unifiedpush.distributor.callback.CallbackFactory
import org.unifiedpush.distributor.nextpush.services.RestartWorker
import org.unifiedpush.distributor.nextpush.services.SourceManager
import org.unifiedpush.distributor.nextpush.services.StartService

object BatteryCallbackFactory : CallbackFactory<BatteryCallbackFactory.MainBatteryCallback>() {

    class MainBatteryCallback : BatteryCallback() {
        override val lowBattery = BatteryCallbackFactory.lowBattery

        private fun restartService(context: Context) {
            if (SourceManager.isRunningWithoutFailure) {
                StartService.stopService {
                    RestartWorker.run(context, delay = 0)
                }
            }
        }

        override fun onBatteryLow(context: Context) {
            restartService(context)
        }

        override fun onBatteryOk(context: Context) {
            restartService(context)
        }
    }

    override fun new(context: Context): MainBatteryCallback = MainBatteryCallback()

    /**
     * Default to false
     */
    private val lowBattery = AtomicBoolean(false)

    fun isLowBattery(): Boolean = lowBattery.get()
}
