package org.unifiedpush.distributor.nextpush.activities.ui

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.material3.TextField
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.LinkAnnotation
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.text.withLink
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import org.unifiedpush.distributor.nextpush.R

@Preview
@Composable
fun NotificationChannelUi(value: String = "", onValueChanged: (String) -> Unit = {}) {
    Column(verticalArrangement = Arrangement.spacedBy(16.dp)) {
        Text(
            buildAnnotatedString {
                append(stringResource(R.string.dialog_add_channel_content))
                append(" ")
                withLink(
                    LinkAnnotation.Url(url = stringResource(R.string.hyperlink_to_channel_example))
                ) {
                    withStyle(
                        style =
                        SpanStyle(
                            textDecoration = TextDecoration.Underline,
                            color = MaterialTheme.colorScheme.primary
                        )
                    ) {
                        append(stringResource(R.string.hyperlink_to_channel_example_text))
                    }
                }
            }
        )
        TextField(
            value = value,
            onValueChange = onValueChanged,
            label = { Text(stringResource(R.string.dialog_add_channel_input_label)) },
            maxLines = 1
        )
    }
}

@Preview
@Composable
fun AddChannelDialog(onDismissRequest: () -> Unit = {}, onConfirmation: (String) -> Unit = {}) {
    var value by remember { mutableStateOf("") }
    AlertDialog(
        title = {
            Text(stringResource(R.string.dialog_add_channel_title))
        },
        text = {
            NotificationChannelUi(value) {
                value = it
            }
        },
        onDismissRequest = {
            onDismissRequest()
        },
        confirmButton = {
            TextButton(
                onClick = {
                    onConfirmation(value)
                }
            ) {
                Text(stringResource(android.R.string.ok))
            }
        },
        dismissButton = {
            TextButton(
                onClick = {
                    onDismissRequest()
                }
            ) {
                Text(stringResource(android.R.string.cancel))
            }
        }
    )
}
